% This code implements Case Study II in the manuscript titled "Assessing
% and Resolving Model Misspecifications in Metabolic Flux Analysis".
%
% Requires: MainAllTests.m 
%
% Written by: Rudiyanto Gunawan
% Date: 14 February 2017

clear
clc
close all

% Add path for RMBNToolbox (please edit accordingly)
addpath /Users/rudigunawan/polybox/ETH/research/'Misspecification Tests for MFA'/RMBNToolbox/src
% Add path to the folder containing the misspecification tests
addpath ..

% Setting up RMBNToolbox parameters
global TYPE_SPECIES; TYPE_SPECIES = 1;
global TYPE_REACTION; TYPE_REACTION = 2;
global TYPE_PARAMETER; TYPE_PARAMETER = 3;

%Set analysis parameters
nrOfTests = 100; %Number of tests

summaryall = [];

for nrOfSpecies = 100
    for nrOfReactionsExchange = 50      
        for nrOfReactionsInternal = 60
            for nrOfReactionsRemoved = [2 5 10]
                for cv = [0.01 0.05 0.1 0.2]
                    pall = MainAllTests(nrOfSpecies,nrOfReactionsInternal,nrOfReactionsExchange,nrOfReactionsRemoved,cv,nrOfTests);
                    
                    % F test
                    index = find(isnan(pall(:,1))==0);
                    TP_F = length(find(pall(index,1)<=0.05))./length(index);
                    FN_F = 1 - TP_F;
                    
                    index = find(isnan(pall(:,2))==0);
                    FP_F = length(find(pall(:,2)<=0.05))./length(index);
                    TN_F = 1 - FP_F;  
                    
                    % LM test
                    index = find(isnan(pall(:,3))==0);
                    TP_LM = length(find(pall(index,3)<=0.05))./length(index);
                    FN_LM = 1 - TP_LM;
                    
                    index = find(isnan(pall(:,4))==0);
                    FP_LM = length(find(pall(:,4)<=0.05))./length(index);
                    TN_LM = 1 - FP_LM;  
                    
                    % RESET
                    index = find(isnan(pall(:,5))==0);
                    TP_R1 = length(find(pall(index,5)<=0.05))./length(index);
                    FN_R1 = 1 - TP_R1;
                    
                    index = find(isnan(pall(:,6))==0);
                    TP_R2 = length(find(pall(index,6)<=0.05))./length(index);
                    FN_R2 = 1 - TP_R2;

                    index = find(isnan(pall(:,7))==0);
                    FP_R1 = length(find(pall(:,7)<=0.05))./length(index);
                    TN_R1 = 1 - FP_R1;  
                    
                    index = find(isnan(pall(:,8))==0);
                    FP_R2 = length(find(pall(:,8)<=0.05))./length(index);
                    TN_R2 = 1 - FP_R2;  
                                        
                    summaryall = [summaryall; nrOfSpecies nrOfReactionsInternal nrOfReactionsExchange nrOfReactionsRemoved cv TP_R1 FN_R1 FP_R1 TN_R1 TP_R2 FN_R2 FP_R2 TN_R2 TP_F FN_F FP_F TN_F TP_LM FN_LM FP_LM TN_LM];
                end
            end
        end
    end
end

summaryall